/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.AliasElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.internal.core.index.IJSCAModel;
import com.aptana.js.internal.core.index.IJSCAParser;
import com.aptana.js.internal.core.index.JSCAParser;
import com.aptana.js.internal.core.index.JSIndexReader;
import com.aptana.js.internal.core.index.JSIndexWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class JSCAFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        if (context == null || index == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                sub.subTask(this.getIndexingMessage(index, context.getURI()));
                IJSCAParser parser = this.getJSCAParser();
                IJSCAModel model = null;
                InputStream is = null;
                try {
                    is = context.openInputStream((IProgressMonitor)sub.newChild(5));
                    model = parser.parse(is);
                    sub.worked(45);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                JSIndexReader jsir = new JSIndexReader();
                List<TypeElement> globalTypes = jsir.getType(index, "Global", true);
                TypeElement global = !CollectionsUtil.isEmpty(globalTypes) ? globalTypes.get(globalTypes.size() - 1) : JSTypeUtil.createGlobalType("Global");
                JSIndexWriter indexer = new JSIndexWriter();
                List<TypeElement> types = model.getTypes();
                List<AliasElement> aliases = model.getAliases();
                URI location = context.getURI();
                for (TypeElement type : types) {
                    PropertyElement property;
                    indexer.writeType(index, type, location);
                    String typeName = type.getName();
                    if (!this.isGlobalProperty(type) || (property = global.getProperty(typeName)) != null) continue;
                    property = new PropertyElement();
                    property.setName(typeName);
                    property.addType(typeName);
                    global.addProperty(property);
                }
                for (AliasElement alias : aliases) {
                    PropertyElement property = new PropertyElement();
                    property.setName(alias.getName());
                    property.addType(alias.getType());
                    global.addProperty(property);
                }
                if (global.hasProperties()) {
                    indexer.writeType(index, global, location);
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    protected IJSCAParser getJSCAParser() {
        return new JSCAParser();
    }

    protected boolean isGlobalProperty(TypeElement type) {
        if (type == null || type.isInternal()) {
            return false;
        }
        String typeName = type.getName();
        return !typeName.contains(".") && !typeName.startsWith("Class<");
    }
}

